"""dev/ release operating system switch for main module."""

# Import built-in modules
from __future__ import print_function

import os
import platform
import sys

# Import local modules
# Add package root to sys.path because we need it for running standalone
this_dir = os.path.dirname(__file__)
package_root = os.path.join(this_dir, "..")
package_root = os.path.abspath(package_root)
if package_root not in sys.path:
    sys.path.insert(0, package_root)

from smartElements.constants import STANDALONE


if STANDALONE:
    try:
        import PySide6
    except ImportError:
        try:
            import PySide2
        except ImportError:
            raise RuntimeError(
                "\n\n{0}\n"
                "No PySide6 or PySide2 binding found. Make sure that one "
                "of them is installed. Checkout smartElement's documentation "
                "for more information how to install it or get in touch with "
                "cragl, we're happy to help you with the setup.\n"
                "{0}\n\n".format("=" * 50)
            )


# development => py files
_OS = platform.system()
if os.path.isfile(os.path.join(os.path.dirname(__file__), ".dev")):
    from smartElements.smartElements_d import *
    from smartElements.license_d import *
    print("smartElements | dev | ", _OS)
# release => cython files
else:
    print("cragl loading: smartElements")

    if _OS == "Darwin":
        from smartElements.smartElements_m import *
        from smartElements.license_m import *
    elif _OS == "Linux":
        from smartElements.smartElements_l import *
        from smartElements.license_l import *
    elif _OS == "Windows":
        from smartElements.smartElements_w import *
        from smartElements.license_w import *


def main(args):
    """Execute main function and create smart_collect window instance."""
    try:
        variant = args[1]
    except IndexError:
        variant = 0

    show_main_ext(variant)


if __name__ == "__main__":
    main(sys.argv)
