"""Trigger custom functionality on selected media."""

# Import local modules
from smartElements import osl
from smartElements.media_commands.send_to_djv import SendToDJV
from smartElements.media_commands.send_to_rv import SendToRV
from smartElements.media_commands.copy_media_paths_to_clipboard import \
    CopyMediaPathsToClipboard

# Register all the media commands here using:
#
# osl.register_media_command(<media command class>)
#
# The media commands will then show up in smartElement's 'Media Commands'
# context menu that appears when selecting and right clicking a media in
# smartElements.
osl.register_media_command(SendToDJV)
osl.register_media_command(SendToRV)
osl.register_media_command(CopyMediaPathsToClipboard)
