"""Add used element to element history.

This import processor will add elements to the element history when a user
inserts them into the DAG.

"""

# Import built-in modules
import os

# Import local modules
from smartElements.settings import Settings
from smartElements.import_processors.base_import_processor import BaseImportProcessor


class ElementHistory(BaseImportProcessor):
    """Add used element to element history."""

    def process(self):
        """Run the processor."""
        self.logger.debug("Adding element to used history %s: ", self.media.base)

        settings = Settings()
        history = settings.get("element_history")

        element_root = os.path.dirname(self.media.path)
        history = [path for path in history if path != element_root]
        history.insert(0, element_root)
        settings.save_setting("element_history", history)
