"""Custom import processors to trigger when importing media into the DAG.

We run only the import processors that are registered in here. So if you create
a custom import processor then make sure that it gets registered in here using:

    osl.register_import_processor(<NAME OF IMPORT PROCESSOR CLASS>)

"""

# Import local modules
from smartElements import osl
from smartElements.import_processors.add_to_used_statistics import AddToUsedStatistics
from smartElements.import_processors.copy_to_workingfile import CopyToWorkingFile
from smartElements.import_processors.count_usage import CountUsage
from smartElements.import_processors.element_history import ElementHistory
from smartElements.import_processors.time_offset import TimeOffset
from smartElements.import_processors.deduplicator import Deduplicator

# Register the import processors.
osl.register_import_processor(CopyToWorkingFile)
osl.register_import_processor(CountUsage)
osl.register_import_processor(TimeOffset)
osl.register_import_processor(ElementHistory)
osl.register_import_processor(Deduplicator)
osl.register_import_processor(AddToUsedStatistics)
