"""Initialize package and add commands to UI."""

# Import third-party modules
import nuke

# Import local modules
from smartElements import osl as smartElements
from smartElements.mvc import helper
# Although these imports are unused here, they are still needed for registering
# custom ingest- and import processors as well as media commands for
# smartElements. Please keep these lines, otherwise these customizations won't
# get registered to smartElements and won't be available.
from smartElements.ingest_processors import custom  # pylint: disable=unused-import, line-too-long
from smartElements.ingest_processors import preview  # pylint: disable=unused-import, line-too-long
from smartElements import import_processors  # pylint: disable=unused-import, line-too-long
from smartElements import media_commands  # pylint: disable=unused-import, line-too-long

# Icons for this package.
_ICONS = helper.load_icons()


def add_to_ui():
    """Add commands to UI."""
    menu = nuke.menu("Nuke").addMenu(
        "cragl/smartElements", icon=helper.load_icons()["logo"])

    menu.addCommand(
        "open smartElements",
        lambda: smartElements.show_main(light=False), "Ctrl+."
    )

    menu.addCommand(
        "open ActionVFX Bridge",
        lambda: smartElements.show_main(light=True), "Ctrl+Shift+."
    )

    menu.addSeparator()

    menu.addCommand(
        "open ingestion matrix",
        lambda: smartElements.show_ingestion_matrix()
    )
    menu.addCommand(
        "register nodes media...",
        lambda: smartElements.show_register_nodes_media()
    )
    menu.addCommand(
        "register selected nodes as toolset...",
        lambda: smartElements.show_register_toolsets()
    )
    menu.addCommand(
        "reveal element from selected node",
        lambda: smartElements.reveal_element_from_node()
    )

    menu.addSeparator()

    menu.addCommand(
        "&about",
        lambda: smartElements.show_about()
    )


add_to_ui()
