"""Extract length of video file."""

# Import built-in modules
import os
import sys

# Import third-party modules
import nuke

# In order to be able to import local modules from smartElements we must add
# the smartElement's packages root to our sys path. Only then are we able to
# import local modules.
PACKAGE_ROOT = os.path.abspath(os.path.join(__file__, "..", "..", ".."))
sys.path.append(PACKAGE_ROOT)


def main(source):
    """Extract data from media.

    Notes:
        We extract data only from footage sources (image sequences/ videos).
        Extracting data from .nk files or 3D data does not make too much sense.

    Args:
        source (str): Absolute path of the source to extract data from.

    """
    source = source.replace("\\", "/")

    read = nuke.createNode("Read")
    read["file"].fromUserText(source)

    number_frames = read["last"].value() - read["first"].value() + 1

    sys.stdout.flush()

    # Wrap data inside keywords that we split away later.
    sys.stdout.write(str(number_frames))

    sys.stdout.flush()


if __name__ == "__main__":
    source = sys.argv[1]

    main(source)
