"""Copy the media paths of all selected media to the clipboard."""

# Import local modules
from smartElements.media_commands.base_media_command import BaseMediaCommand
from smartElements.pys import QtGui


class CopyMediaPathsToClipboard(BaseMediaCommand):
    """Copy the media paths of all selected media to the clipboard."""

    def label(self):
        """Return the label to use in the UI for this command.

        Returns:
            str: The label to use for the command in the UI.

        """
        return "Copy media paths to clipboard"

    def process(self, media):
        """Copy the media paths of all selected media to the clipboard.

        Args:
            media (:obj:`list` of :obj:`smartElements.media.Media`):
                Sequence of selected Media instances. Wil send all selected
                media to DJV.

        """
        paths = [element.path for element in media]
        paths = "\n".join(paths)

        clipboard = QtGui.QClipboard()
        clipboard.setText(paths)
