"""Update any meta dada."""

# Import built-in modules
import json

# Import local modules
from smartElements import paths
from smartElements.ingest_processors.base_ingest_processor import BaseIngestProcessor


class MetadataUpdater(BaseIngestProcessor):
    """Update any meta dada."""

    def process(self):
        """Run the MetadataUpdater process."""
        meta = self.settings.get("meta")
        if not meta:
            self.logger.info("No metadata to update. Skipping.")
            return

        self.logger.info("Updating metadata: %s", meta)

        metadata_path = paths.get_meta_path(self.job.parent_dst)

        self.logger.info("Writing meta data to: %s", metadata_path)
        with open(metadata_path, "r") as file_:
            data = json.load(file_)

        for key, value in meta.items():
            self.logger.info("%s -> %s", key, value)
            data[key] = value

        with open(metadata_path, "w") as file_:
            json.dump(data, file_, indent=4)
