"""Reference element via postage stamp in case DAG already contains that element."""

# Import local modules
from smartElements.import_processors.base_import_processor import BaseImportProcessor
from smartElements.media import Media


class Deduplicator(BaseImportProcessor):
    """Reference element via postage stamp in case DAG already contains that element."""

    def process(self):
        """Run the processor."""
        if self.is_toolset:
            return

        import nuke

        media = Media(self.path)

        file_nodes_with_this_media = sorted(
            [
                node for node in nuke.allNodes()
                if node.knob("file")
                and node["file"].value()
                and Media(node["file"].value()).filename_base == media.filename_base
            ],
            key=lambda node: node.name(),
        )

        if len(file_nodes_with_this_media) > 1:
            postage = None
            for index, node in enumerate(file_nodes_with_this_media):
                if index == 0:
                    continue

                postage = nuke.createNode("PostageStamp", inpanel=False)
                postage.setInput(0, file_nodes_with_this_media[0])
                postage["hide_input"].setValue(True)

                nuke.delete(node)

            if postage:
                nuke.zoom(1.0, (postage.xpos(), postage.ypos()))
