"""Count the usage of media when it is inserted.

This import processor will increase the `usage` counter in the media's
meta.json so that we can get a sense about which elements are used most often.

"""

# Import built-in modules
import json
import os

# Import local modules
from smartElements.constants import JSON_INDENT
from smartElements.import_processors.base_import_processor import BaseImportProcessor  # pylint: disable=line-too-long


class CountUsage(BaseImportProcessor):
    """Count the usage of media when it is inserted."""

    def process(self):
        """Run the processor."""
        if not os.path.isfile(self.meta_json):
            self.logger.debug("Media does not contain a meta.json file. "
                              "Exiting early.")
            return

        with open(self.meta_json, "r") as file_:
            meta = json.load(file_)

        used_count = "used_count"
        if not meta.get(used_count):
            meta[used_count] = 0
        meta[used_count] += 1
        self.logger.debug("Increasing used count to %s", meta[used_count])

        with open(self.meta_json, "w") as file_:
            json.dump(meta, file_, indent=JSON_INDENT)
