"""API for this package.

This module contains functions that had to be moved out of the license module
because when cythonizing, they raise unsolvable UnicodeDecodeErrors. They run
successfully though in .py and .pyc files though which is why they are brought
to here.

"""

# Import built-in modules
import base64
import logging
import os

# Import local modules
from smartElements.constants import LOGGING_FORMAT
from smartElements.media import Media

# Initializing our logger.
logging.basicConfig(format=LOGGING_FORMAT)

__all__ = [
    "Media",
]


def root():
    """Get the root directory of this package.

    Returns:
        str: Absolute path of the python package.

    """
    return os.path.dirname(__file__)


def write_stream(path, vals, py):
    """Write stream into file.

    Args:
        path (str): Absolute path to write stream to.
        vals (:obj:`list` of :obj:`str`): Sequence of strings to write.
        py (int): The major python version that is currently running,
            i.e. 2 or 3.

    """
    if py == 3:
        enc = bytes(vals)
        with open(path, "wb") as out:
            out_enc = base64.urlsafe_b64encode(enc)
            out.write(out_enc)
    elif py == 2:
        with open(path, "wb") as out:
            data = "".join(vals)
            out_enc = base64.urlsafe_b64encode(data)
            out.write(out_enc)
