Changelog
=========

2.58.1
------
  - Drop support for nuke-13 and below, Fix core dumped on some menu entries (#253)

    Align with Foundry's policy and stop supporting legacy Nuke versions.

2.58.0
------
  - Used in - Keep record of working file paths in elements metadata (#106)

    When Bringing an element into a working file, that working file's path gets stored
    in the element's metadata. You and any other users can right-click an element and navigate
    to the ``Used in...`` menu to get a list of all working files that use that element. Clicking
    a path in that ``Used in...`` menu lets you then reveal that path in your explorer.
    
    This helps to quickly navigate to working files that use that element and lets you for example 
    quickly bring in the node setups that used that element without wasting time to re-invent any 
    node setup.
    
    If not wanted, you can disable creating a record for your working file's usage in the 
    smartElement's settings. Inside the ``Import Processors`` settings set 
    ``AddToUsedStatistics``'s ``enable`` to ``false``.

  - Add import processor: Deduplicator (#12)

    When bringing in an element that is already referenced in the DAG then this creates a
    postage stamp referencing the already read in element instead of creating another Read node.

  - Ensure minimum width to not cut off text in dropdown menus (#251)

2.57.0
------
  - Mark elements as 'new' using a configurable time range (#233)

    This feature lets you configure an individual time range to mark elements as 'new'. If
    an element has been ingested within that time range (e.g. within the last '24 hours', '5 days',
    '3 months', etc.) then smartElements marks these elements as 'new'. This helps you to better and
    quicker identifying new elements.

  - Mark elements that contain comments (#209)

  - Expose 'View element details' in context menu (#243)

    Right-click an element and choose 'View element details' to show the
    currently selected element's details. Shortcut: Hold 'Alt' (release 'Alt'
    or press escape or click the close button to close the element details 
    view).

  - ActionVFX: Use svg logo format to make logo sharper (#244)

  - ActionVFX: Hide category title thumbnail in gallery mode (#245)

  - ActionVFX: Adjust download entry to download high-res variants (#246)

2.56.1
------
  - Fix: Expose only gallery mode for third-party stacks (#239)

    At this stage, list and filmstrip view don't make too much sense for
    third-party stacks. For that, we updated to expose only gallery viewing
    mode.

  - Fix aspect of third-party stack element video previews (#240)
  
  - Hide default stack in ingest matrix when env var is set (#238)

    Setting the environment variable 'CRAGL_SMARTELEMENTS_HIDE_DEFAULT_STACK'
    to True will hide the 'default' stack in smartElements and also in the
    ingestion matrix.

2.56.0
------
  - Implement ActionVFX Bridge (#213)

    The ActionVFX Bridge is a free to use smartElements variant that lets
    you browse and download ActionVFX exclusively. For the ingesting step
    you require a smartElements license.

  - Add 'Remove all' button in ingest matrix (#235)

    The 'Remove all' button removes all rows after having confirmed it.

  - Create animations (#231)

    This update adds some fancy transform and blending over animations. Just
    for fun. Animations get enabled by default. However, if you don't like
    these you can turn them off in the smartElements settings section.

  - Expose help button in AI Generator view (#228)

    In order to increase usability, the AI Generator view contains now a
    help button at the top right. Clicking it browse you to the online
    documentation for the AI Generator.
  
  - Tags: Keep TagEditor open when adding/deleting a tag on an element (#201)

    This improves the usability and does no longer close the TagEditor after
    having executed such actions.

  - Settings: Move ingest and import processor help buttons to top right (#229)

  - Improve tooltips (#230)

  - Remove 'Clear' command (#232)

    The 'Clear' command in the element's context menu cleared the visible
    content of the currently selected list. We decided to deprecate this
    command as it turned out to be not that useful.

  - Fix: Metadata View has no attribute button_open_ingestion_matrix (#225)

2.55.0
------
  - Log in to your ActionVFX account, download & ingest owned products (#212)

    The ActionVFX stack contains now functionality to log in to your ActionVFX
    account. Once logged in you can autodownload and ingest all owned 
    elements - That includes free and purchased elements / libraries.

  - Add Vendor Logo to third-party stacks (#223)

    Each third-party vendor stack contains now a vendor logo. Clicking it
    navigates you to the vendor's website.

2.54.0
------
  - Access Fullres ActionVFX Practise footage (#215)

    You can now access all ActionVFX Practice Footage libraries in fullres!

    Switch to the 'ActionVFX-Practise-Footage' stack, log in, right-click any
    element and choose a download variant to your needs. These get automatically
    downloaded and send to the ingestion matrix so that you can ingest these
    from here and have them available in your preferred format.

  - Access Cache Previews in top toolbar for third party elements (#218)

    Click the Cache Previews button in the top toolbar to auto download all
    previews for all third party elements. Once cached, this loads third party
    lists immediately as the preview thumbnails are cached onto disk.

  - Add home view for all third-party stacks (#219)

    All third-party stacks contain now also a home view that shows you all
    lists of the current stack.

2.53.0
------
  - Import and export live filters (#206)

    By right-clicking the live filter list, you can now import and export live
    filters. This opens up sharing live filters amongst users and lets you
    de-clutter your live filters without the need to delete them.

2.52.0
------
  - Implement GenAI models for video and image generations (#200)
    
    This update implements an AI video and image generator that provides
    generative AI using the following models:

        Video models:
            - google/veo-2
            - pixverse/pixverse-v4.5
        
        Image models:
            - black-forest-labs/flux-1.1-pro-ultra
            - black-forest-labs/flux-1.1-pro
            - black-forest-labs/flux-schnell

    Please see documentation for more information.

2.51.0
------
  - Implement ActionVFX into smartElements (#199)
    Besides FXElements, we have now also implemented ActionVFX into
    smartElements, so you can browse all their collections right inside Nuke,
    insert previews for all their offered elements into your nodegraph and
    browse to their online collections easily.

  - Add convenience function to download all third-party elements thumbs (#198)
    
    Right click any third-party list and choose 'Cache previews...' from
    the context menu. The upcoming dialog lets you then download all thumbnails
    for all lists in the current third-party web stack in one go. This lets
    you easily and more quickly browse everything a web stack offers for you.
 
2.50.0
------
  - Pin/Unpin a list (#181)

    Right click any list and pin it to the top. Right click it again and unpin
    it. A pinned list shows up at the top, no matter its name. This lets you
    quicker find lists that you constantly refer back to.

  - Copy/paste playlist path to and from clipboard (#182)

   Right-click a playlist and copy its path to the clipboard and share it
   with other users. They can then right-click and import that playlist.

  - Filter favorite elements regardless of favorite rate number (#162)

    Click the favorites menu and select 'any rating' to filter all elements
    that contain any favorite number between 1 - 5. This gives you a good
    overview on all your favorite elements no matter their actual favorite 
    value.

  - Make pagination work with tags and live filter (#171)

2.49.0
------
  - Copy element path - paste element path (#194)
  - Drag file.txt that contains folder paths for ingestion (#183)
  - Copy to working file import processor: Ensure forward slashes (#192)
  - Sanitize all terminal command paths (#191)
  - Update flip/flop/flipflop to hotkey 'E' (#176) 
  - Fix scrolling in Nuke-12 (#191)

2.48.1
------
  - Fix incorrect framerange when transcoding during ingestion (#190)

2.48.0
------
  - Configure to show element count (#187)

    In the settings section you will now find a checkbox 'Show element count'.
    When having it checked then this displays the number of elements for each
    list.

  - Add Overview documentation video to written documentation (#188)
    
    The overview documentation video is now available in the Videos' page.

  - Confirm aborting ingestion when closing ingestion window (#189)
    
    When closing the ingestion matrix while having ingestions processing you 
    are now asked to confirm aborting these.

2.47.0
------
  - Auto reload library when creating a new toolset (#177)

  - Fix: Use custom thumbnail when registering a new toolset (#180)

  - Show HOME section only in gallery view (#178)

  - Ingestion: Prevent from ingesting when no list is selected (#179)

2.46.0
------
  - Run smartElements in standalone mode (#174)

    smartElements can now be launched outside of Nuke. For that you will now
    find a 'standalone' folder inside your smartElements installation which
    contains launchers for each operating system. The standalone mode offers
    everything you get inside Nuke. Please note that you will need a Qt binding
    (PySide2 or PySide6) installed as well as Python-3. For media ingestion
    you require Nuke and will need point smartElements to its executable. 

  - Remember window size (#175)

    When resizing the smartElements window it will now remember its size. The
    next time you launch it, it will contain the same size.

2.45.0
------
  - Create temp playlist (#173)

    Create a temporary playlist that lasts only for the current session.
    Unless you right-click it and choose 'Save permanently...' from the
    context menu in order to make it a permanent playlist.
    Temporary playlists are useful when you just need a place for temporary 
    element collection without the need to permanently save them... unless
    you change your mind.

2.44.0
------
  - Implement trash bin (#143)

    Each stack contains now a trash bin. Right click one or multiple elements
    and choose 'Move to trash' from the context menu to move them to the
    trash location. From there you can revive elements if you change your mind, 
    or delete them permanently. This makes removing elements more    secure.

  - Use arrow in all QComboBox widgets (#167)

    In order to increase usability and make it more obvious, all dropdown
    menus have got a down arrow now. 

  - Fix: Replace element thumbnail (#170)

2.43.0
------
  - Update to nuke-16 (#172)

2.42.0
------
  - Integrate FX Elements third-party element web stacks (#130)

    You can now browse the entire FX Elements library directly inside
    smartElements! All elements provide previews that let you judge if an 
    element will fit in your comp. You can even download free full resolution 
    clips and use them right away. For more information checkout the
    online documentation.

2.41.0
------
  - Ignore @eaDir when bringing elements into DAG (#169)
    
    NAS servers that create internal metadata '@eaDir' directories mess with 
    the internal element structure. These get now ignored when bringing
    elements into the DAG.

2.40.0
------
  - Reveal element from selected node (#168)
    
    Select a Read node and execute "cragl/smartElements/Reveal element from 
    selected node". If this an element in smartElements it will be revealed. 
    This helps to find related elements and get more information about that 
    element.

  - Clear selection after having inserted elements into DAG (#164)

2.39.2
------
  - Fix: Ingest to stack that has been added via environment variable (#166)

  - data_extraction: Write metadata.nk to element root, not source root (#165)

    This update makes sure the metadata.nk file that gets created during
    element ingestion gets always written into the element's root location,
    not next to the source. This makes a difference when using soft imports.

2.39.1
------
  - Fix ingestion data extraction when using soft copy (#163)

2.39.0
------
  - Implement element ingestion matrix (#148)

    Dragging media sources into smartElements launches now the smartElements
    ingestion matrix. This window lets you manage your ingstions and set up
    various things - including media transcodings during the ingestion.
    For more information how the ingestion matrix works please refer
    smartElement's media ingestion documentation page.

2.38.0
------
  - Optimize for fullscreen mode (#159)

    The element widgets scale now with the main window when resizing it.
    The display for gallery view has been improved.

  - Speed up media crawl when ingesting (#158)
  
    Dropping a folder scans it for all ingestable media before the actual
    ingestion starts. This crawl process has been massively speed up.

  - Add hotkey overview (#144)

    smartElements contains multiple hotkeys. The help menu (top right in the
    main window) contains now a hotkey overview so that you can quickly
    refer back to these.
  
  - Override hard/soft copy ingestion mode via environment variable (#160)

    Set the environment variable 'CRAGL_SMARTELEMENTS_INGEST_HARDCOPY' to 
    'True' to enforce ingesting using a hard copy, i.e. the media to ingest
    gets physically copied to the selected list.
    Set the environment variable 'CRAGL_SMARTELEMENTS_INGEST_SOFTCOPY' to
    'True' enforce ingesting using a soft copy, i.e. the media to ingest does
    NOT get physically copied to the selected list. When inserting the media
    into a working file this will then reference the original media.
    Use one of these environment variables. These override any import processor
    settings when they are set.

  - Keep filter when switching viewing modes and switching lists (#156)

    When switching viewing modes and lists the currently set up element
    filter gets preserved.

  - Wrap very long element names into multiple lines (#157)

    Very long element names get not wrapped into multiple lines to ensure
    the full element name gets preserved. This happens in the list view
    and in the element quick info view.

  - Move selected elements to other category (#161)

    Select one or many elements, right click and choose 'Move...' from the
    context menu. In the upcoming dialog choose the new list to add the
    selected element(s) to.

2.37.0
------
  - Add live filter (#153)
  
    This update adds a live filtering feature into smartElements. While the
    lists and tags section let you categorize and group elements, the live 
    filter feature lets you apply complex filtering to find exactly what you 
    need across all category lists. Any new element that matches the given
    rules shows up in the live filters, too.

  - Implement to abort ingestion (#152)
  
    When ingesting elements you will now find an 'Abort Ingestion' button on 
    the bottom left. Clicking it will abort all open ingestion jobs  in the 
    ingestion queue. Elements that have been fully ingested remain.
  
  - Search: Allow regular expressions (#154)  
  
    The search section allows now to enter regular expressions. This gives
    you a lot more flexibility to find exactly what you need.
  
  - Fix ingest via api in standalone mode exited silently (#151)

2.36.0
------
  - Add element history section (#117)
  
    Press P or click the element history button at the top of smartElements to
    view the history of recently used elements. Click the insert button to
    insert these in your DAG. Click the reveal button to navigate to the
    element in your library inside smartElements.

  - Auto set thumbnail (#139)
  
    The 'thumbnail_frame' in the PreviewCreator ingestion processor is now
    by default set to 'auto'. This will automatically find out and set the
    most representable thumbnail frame when ingesting.
    
    You can also auto set thumbnails on multiple elements in one go. Select
    multiple elements and choose from the context menu:
    'Preview -> Set thumbnail -> auto'
    This becomes quite handy on elements that start and end with a back
    background, e.g. muzzle flashes, explosions, dirt charges, etc.

  - Search: Add 'is not' and 'does not contain' operators (#147)

    When searching for elements you can now also the 'is not' and 'does not 
    contain' operators to filter out any element that does not meet a given
    condition.
    
  - Use more accurate progress bar when ingesting (#149)

    Elements that are currently ingesting show a progressbar. In previous
    versions this showed only a progress step per run ingestion processor.
    With this update we have made the progress more detailed and added more sub
    steps. This gives you a more accurate result where an element's current
    ingestion status currently is.  
  
  - Settings - ingest processors | import processors: show help buttons (#140)
  
    Add help button that browses users to advanced documentation section
    directly. The advanced documentation section shows configuration values
    to use for ingest and import processors.
  
  - Playlist widget list: don't show playlists that don't exist on disk (#109)

    Over time you might remove playlists from disk when they are no longer
    needed. With that, they shouldn't be displayed in smartElements anymore
    when they are not accessible anyways.

2.35.0
------
  - Create element ingestion report (#145)
  
    Right click a list and choose 'Generate new elements report...' from the
    context menu. This launches a dialog in which you can specify the time 
    range of newly ingested elements to put into a report. You can export as
    HTML, PDF and CSV file.

2.34.0
------
  - Add API (#77)

    smartElements provides an Application Programming Interface (API) which
    lets you communicate with smartElements from the outside. This lets you
    for example query stacks, lists, settings and elements and manipulate them,
    add new entries, update and delete them and ingest new elements -
    everything outside of smartElements and outside of Nuke. This lets you now 
    to perform automations of various kinds without the need to use 
    smartElement's graphical user interface (GUI). For more information 
    please refer to the API section in our documentation.

2.33.0
------
  - Add additional metadata and search elements by metadata (#137)

    Right click one or several elements and execute 'Add metadata' from the
    context menu to add additional metadata for all selected elements.
    Elements can now also be searched by metadata.

  - Search elements by width, height, frame length (#114)
  
    When filtering elements you can specify the width, height and frame length.
    You can search elements that have exactly the entered value as well as
    less than and more than the entered value. 

2.32.0
------
  - Update to nuke-15 (#135)
  - Fix: Stop player when element is no longer played (#134)

2.31.0
------
  - Gallery View: Show QuickInfo (#133)

    The gallery view contains now a configurable quick info that lets you view
    additional information for all elements like name, resolution and used
    count so that you can quicker find what you are interested in.
    The quick info and the details to show can be turned on and off in the 
    settings section.

2.30.0
------
  - Add Home View showing preview thumbnails for each list (#132)

2.29.0
------
  - Implement element Head-up-Display (#123)

2.28.1
------
  - Speed up launching time when being in offline mode (#131)

    If your machine is not connected to the web we recommend to set the
    environment variable ``CRAGL_NO_WEB`` to ``'True'``. This will speed
    up launching smartElements.

2.28.0
------
  - Add button to toggle play/stop all elements (#119)
  - Play all selected elements (#122)
  - Notify when trying to ingest to the 'ALL' list (#120)
  - Fix: color dialog is under smartElements main window on windows (#126)

2.27.0
------
  - Add studio model (#116)

2.26.0
------
  - Bulk adjust thumbnail for multiple elements (#113)

    Select multiple elements and set thumbnails for all of them in one go.
    This is particularly useful if your current list contains many elements
    that start with a black frame like smoke, dust, fire, explosions, etc.
    and progress over time. In these cases using a middle or end frame as
    thumbnail should get you 95% there and you can tweak the thumbnails
    for specific elements manually afterwards.

  - Add filter section, order elements in ascending and descending order (#107) 

    The element search widget was moved into a dedicated filter section that
    can be toggled in visibility (shortcut: F).

  - Drive visibility of local 'default' stack by environment variable (#112)

    Setting the environment variable CRAGL_SMARTELEMENTS_HIDE_DEFAULT_STACK
    to True will hide the local 'default' stack. This environment variable
    is useful for larger studios in combination with the environment variable
    CRAGL_SMARTELEMENTS_ADDITIONAL_STACKS to drive the visibility of stacks
    seen by the artists.

  - Fix: Deleting all stacks lets a user not create a new stack (#110)

    In previous versions, smartElements always required having one active stack 
    set. One user mistakenly removed all stacks from the stacks dropdown menu.
    This caused some issues in various places as smartElements needs an
    active stack and this prevented the user from restoring stack locations 
    back to their settings.
    This has been fixed. You can now remove all stacks from the stacks
    dropdown - either willingly or mistakenly - and can then add stacks back
    to the stacks dropdown menu without running into an issue. 

2.25.0
------
  - Make preview frame to use when ingesting configurable (#108)

    The 'Ingest Processors' section in the settings contains now a
    'thumbnail_frame' configuration for the 'PreviewCreator' ingestion 
    processor. Choose between 'start', 'middle' or 'and' to automatically
    render the first, middle or last frame of each element as thumbnail frame
    when ingesting. 

2.24.0
------
  - Configure to mark new elements (#105)

    This update adds a new checkbox 'Inform about new elements'. Turning it
    on will mark all elements that get ingested from now on with a green 
    border. This accounts only for elements that weren't ingested by yourself
    of course. Elements can be marked as seen then.

2.23.0
------
  - Versionize elements (#101)
  
    Right click any element and choose 'New version...' from the context menu
    to create a new version for the element. Any regular element insertion
    uses always the latest version; Use the version dropdown in the SideBar
    info panel to insert an explicit version.
    Element version paths stay consistent so nothing used gets offline.
  
  - Support .mxf video files (#103)
  
    This update lets you now ingest .mxf files that are natively readable in
    Nuke.

2.22.0
------
  - Colorize lists, tags and elements to quicker find items (#100)
    
    Lists, tags and elements can now be tinted with a custom color to quicker
    find often used items. Right click any list from the elements list on the 
    left, any tag from the tag list on the left or any element in the library 
    and choose 'Color -> set' from the context menu to set a custom color. 
    Choose 'Color -> unset' to remove the custom color.
    
    Custom colors get stored locally on a user basis so each user can set their
    own colors.

  - Add additional data to elements (#102)
  
    Sometimes it is desirable to store any additional data to an element,
    e.g. color file, license file, footage for toolsets, etc. This update lets 
    you do that. Right click an element and choose 'Add additional files' from 
    the context menu. When bringing an element into your DAG that contains 
    additional element files you will be asked if you would like to reveal 
    the additional element files. In smartElement's settings you can change 
    that policy from 'ask' to 'always' reveal or 'never' reveal.
    
  - Keep info window fully in screen (#99)
    
    Hover over an element and hold the Alt key to get additional information 
    about the element in the element info window. In previous versions the
    info window was moved under the current mouse cursor position, however
    when the library is located near the bottom of the screen then the
    info window was cut off. We removed moving the info window under the
    current mouse cursor position.
    
2.21.0
------
  - Update to nuke-14 (#98)

2.20.0
------
  - Implement favorite sync to view favorites from other users (#92)

  - Add 'All' list that shows all elements of a stack (#97)

2.19.0
------
  - Add 'jkl' shortcuts to rewind, play/stop, forward for video widget (#91)

    Hold ctrl/cmd and press j and l to rewind/play in sub steps. When bringing 
    an element into node graph the speed mode gets applied to the node as well 
    using a Retime node. The UI also gained a playback speed dropdown to adjust
    the current video playback speed. Note that this dropdown as well as the
    shortcuts are only available when setting the playback mode in
    smartElement's settings to 'loop'. When being in 'scrub' mode this won't
    be applied.

  - Toggle flip flop mode for videos using shortcut 'f' (#96)

    Hover over a video and press f to toggle between normal viewing mode,
    flip, flop and flip-flop. When bringing an element into node graph the
    viewing mode gets applied to the node as well using a Mirror node.

2.18.1
------
  - Fix: Custom onDrop callback overwrites default drop callback (#95)

2.18.0
------
  - Implement media playlists (#83)

    Media playlists are collections of media from any list in any stack. They
    let you bundle media elements that you can then re-use and share with your 
    team. 

2.17.0
------
  - Enhance overall performance and speed up ingesting elements (#89)

    smartElements has gained an additional performance boost. Especially 
    ingesting elements should now be a lot faster and smoother.

  - Show element info as tooltip (#80)

    You can now enable element info as tooltip. Whenever you hover over an
    element, important information for the current element will be displayed
    immediately. Showing element info as tooltip can be enabled and disabled
    in the settings by checking/unchecking the 'Show element info tooltip'
    checkbox.

  - Lock selected stacks via environment variable (#81)

    Stacks that are listed in ``CRAGL_SMARTELEMENTS_LOCKED_STACKS`` will be
    locked. Concatenate multiple paths with the operating system's path 
    separator.

  - Show current stack in window title (#87)  
  
    The currently selected stack gets now shown in smartElement's window title.

  - Add progressbar for ingesting jobs (#85)

    Each element contains a progress bar while ingesting to show the current
    progress when ingesting.

  - Add element ingestion live log (#90)

    The ingestion log can be viewed live to see where the element is currently
    at.

2.16.0
------
  - Add sidebar info on the right (#76)

    Clicking the sidebar info button on the top left launches the sidebar info 
    on the right. This widget gives  you more information about the currently 
    selected element and lets you trigger certain actions like inserting, 
    setting favorite rate, exploring  in explorer, adding tags and comments, 
    etc. Use Ctrl + -> to show the sidebar and ctrl + <- to hide it.

  - Add documentation button (84)

    A documentation button was added to the top right of the smartElement's
    main window. Clicking it browses to smartElement's online documentation.

  - Fix: Metadata is not correctly ingested when ingesting under Nuke-13 (#86)

2.15.1
------
  - Fix: Ingesting broke with previous update (#82)

2.15.0
------
  - Add functionality to mark elements as deprecated (#79)

2.14.0
------
  - Fix: Filmstrip view does not display the last element (#78)

  - Ingest from .txt file (#74)

    Drop a .txt file containing one media path per line and smartElements will 
    ingest all these stated media elements into the currently selected list.

2.13.0
------
  - Implement filmstrip viewing mode (#75)

    smartElements offers a thumbnail view and a list view to view elements. 
    Now, it gained another view - the filmstrip view. This view contains 
    thumbnails in a horizontal layout and a large video player. This view 
    helps you to quicker watch all elements in a larger format and in more 
    detail.

2.12.0
------
  - Add fullscreen player mode (#73)

    Select an element from the library and press the spacebar to view it in
    fullscreen mode. Press the spacebar again to leave fullscreen. While
    in fullscreen mode you can also use the arrow keys to cycle through
    different elements.

  - Add comment to element in thumbnail view (#71)

    Comments can now also be added in thumbnail view. Right click an element
    and choose 'Comment' to enter/update a comment on the currently selected 
    element in thumbnail view. A comment adds useful information for you and
    others and you can search for elements by comment.

  - Improve favorite rating system (#68)

    In previous version an element could either be set as favorite or not.
    Now, each element can get a rating from 0 up to 5 stars and you can
    individually view elements of these ratings to better differentiate
    between favorite elements.

2.11.0
------
  - Add context menu command to play all elements at once (#67)

    Right click any element and choose 'View -> Play all' from the context menu
    to play all elements from the current list at once. Choose 
    'View -> Stop all' to stop all elements. Having the ability to watch all 
    elements playing at once gives flexibility in viewing many elements in 
    context to each other. This can then sometimes enhance quicker finding 
    fitting elements for your current needs.

2.10.0
------
  - Show progressbar when loading elements (#64)
  
    When loading elements, this update will now show a progress bar at the
    bottom left, indicating the current loading progress.
  
  - Use continuous loading for elements (#65)
  
    In previous versions, -all- elements of a list had loaded in the background
    before displaying. With this update we use a continuous load approach
    in order to quicker serve you with using elements.
  
  - Add elements view limit (#66)

    At the top right of the smartElements main window you will now now find
    widgets to limit loading by n elements in order to quicker serve you with
    using elements.

2.9.1
-----
  - Fix ImportError for Python-3 (#63)

2.9.0
-----
  - Introduce media playback option, implement to scrub media (#60)
  
    In the settings section you can now configure the behavior of media 
    playback. Setting it to 'loop' will loop the media as long as you hover 
    over it. Use 'scrub' to scrub through the media by moving your mouse.

  - Support ingesting R3D files (#58)

  - Fix creating full length preview when ingesting .mp4 files (#61)

  - Add most used section (#62)
  
  - Add history section (#59)

2.8.1
-----
  - Fix dropping license into license window raises UnicodeDecodeError (#57)

2.8.0
-----
  - Fix reading trial license data fails decrypting (#55)
  - Send email to license author when machine installs license (#56)

2.7.1
-----
  - Port to Nuke-13 (#39)
  - Fix: Paste tag from clipboard needs Nuke restart to show tagged media (#54)
  - Show media in alphabetical order in tag view mode (#55)
  - Fix: Sending media with white space to RV does not resolve to path (#52)
  - Fix: Use multiple video files when it has a file sequence like naming (#53)
  - Fix: Setting thumbnail for toolset does not process under Windows (#51)
  - Upload custom thumbnail: lower file extension to check for (#50)

    This allows to upload for instance .JPG files as well as .jpg files. 

2.7.0
-----
  - Add custom media commands to trigger custom code on selected media (#43)

    This update adds functionality to trigger custom commands on selected
    media. This gets done by registering media commands classes to
    smartElements that we automatically pass selected media to. How this works
    gets discussed in the smartElements 'advanced' documentation page. 

2.6.2
-----
  - Disable register renderings by default (#49)

    We changed the default value to register renderings to disable it. If you
    want to use this feature you can enable it in the settings.

2.6.1
-----
  - Fix: Search does not contain matching elements (#47)
  - Remove non matching elements in search in list view (#48)

2.6.0
-----
  - Search lists and tags (#41)
  
    The main window contains inputs to search for lists and tags. This is
    primarily useful if you have lots of lists and tags.
  
  - Add additional stacks via environment variable (#40)
  
    The stacks dropdown menu gains additional paths when having the environment
    variable ``CRAGL_SMARTELEMENTS_ADDITIONAL_STACKS`` set. Similar to adding
    paths to the ``PATH`` and ``PYTHONPATH`` environment variable, you can
    specify multiple paths by concatenating them using the operating system
    path separator. Under Linux and MacOS this is a **colon**. Under Windows
    this is a **semicolon**.
    This feature is primarily useful for a studio in case you want your artists
    to have access to additional stacks without the need to add them manually
    per machine.

  - Add functionality to rename an element (#42)
    
    This update adds a 'rename' command to the media's right click menu to
    rename the selected media. Please note: This will rename the element's name
    in the meta data only so that it will only be renamed in the UI. This will
    not rename the physical files, otherwise this would raise the risk of
    making media offline in case the media is already referenced in other
    working files.
  
  - Fix: Clicking cancel button will still perform deletion (#44)

  - Fix: Move Tag window and Info window onto the top under Linux (#45)

  - Fix: Typing T into the tag window's input closes the tag window (#46)

2.5.0
-----
  - ItemInfo widget: Update thumbnail directly without creating snapshot (#23)

2.4.0
-----
  - Speed up running in offline mode (#38)

2.3.0
-----
  - Filter elements by selected tags using an 'any' / 'all' mode (#34)
  
    When being in tag filtering mode, the tag list contains two radio buttons
    that let you choose how to view elements for the selected tags:
     
      - **any**: Show all elements that contain *any* of the selected tags.
      - **all**: Show only elements that contain *all* of the selected tags.

  - Add remember function when asking for re-ingesting or skipping media (#35)
  
    When ingesting multiple media that is already contained in another list
    then you can check a 'remember' checkbox that will apply your clicked
    decision about ingesting or skipping to all dropped elements. The remember
    function works for the currently dropped elements. Then same remember
    mechanism applies for asking about re-ingesting media that is already
    contained in the currently viewed list.
  
  - Fix: Ingesting a mov file shows frames count 1 in metadata (#29)
  - Fix: Re-ingesting existing media in gallery mode hid the whole row (#37)
  
2.2.0
-----
  - Close tag editor when loosing focus (#32)
  - Close current tag editor when opening another tag editor (#36)
  - Add multiple tags at once by concatenating them with comma (#31)
  - Copy tags, paste tags from one element to another (#30)

2.1.0
-----
  - Add tagging system (#20)
  
    You can now organize your media by using a tagging system. The element
    browser contains now a tagging list at the bottom left. This gives you the
    freedom to not depend on any sorting on your hard drives anymore - You can
    ingest and simply sort afterwards. An element can contain several tags and
    an element can occur in several tag lists. This gives you more flexibility
    in organizing your media if required. In order to tag elements, select one
    or multiple elements and press 'T' or choose 'Tag' from the context menu.
    In the upcoming pop up you can edit and update a media's tags.
    
  - Keep original aspect ratio of media previews (#21)
  
    When ingesting media that is not in an aspect ratio of 16/9 the preview
    image got distorted in previous versions. Previews get always generated in
    an aspect ratio of 16/9 in order to have an even layout. In case media is
    outside of this aspect ratio, we use a letter/pillow box for the preview.
    The actual media's aspect ratio stays of course untouched.

  - Restrict modifying permissions when having environment variable set (#22)

    Having the environment variable 'CRAGL_SMARTELEMENTS_ALLOW_MODIFICATIONS'
    set to 'True' or having explicitly not set this environment variable (to
    keep backwards compatibility; We always want all users to being able to
    modify data by default as all users should be responsible users) will
    allow all modification operations (creating lists, ingesting media,
    updating media, deleting media, etc.). Having this environment variable
    explicitly set to 'False' will disable any modification functionality. A
    studio can then decide if they want to restrict their users to be able to
    modify data or not.

2.0.0
-----
  - Revamp media video player (#16)

    Media videos should now play out of the box regardless the Nuke version. No
    additional codec installation is necessary anymore.

    Note: Revamping the media video player means a major version update because
    we not only refactored a lot of code, we also dropped a lot of code due to
    simplifying the video player widget, which created an API breaking change.
    The previous limitation of the used Nuke version and having an h.264
    decoder and encoder installed on your machine should now not be necessary
    anymore.

  - Add functionality to set one or multiple poster frames for media (#11)
  
  - Add hotkeys to ItemInfo widget (#13)
    - F1: Toggle showing/hiding the video/static image
    - F2: Toggle showing/hiding the poster thumbnails
    - F3 or I: Toggle Insert the media into the node graph
    - F4 or R: Toggle Reveal the media in your explorer
  
  - Add hotkeys to insert and reveal element (#15)
    - I: Insert the elements that are currently selected in the table into 
    your node graph

    - R: Reveal the elements that are currently selected in the table in your
      file explorer

  - Set media's viewing (normal, flip, flop, flip-flop) and playback speed

    The video player's context menu contains two new menus 'View' and 'Speed'.
    'View' lets you flip, flop and flip flop the selected media. 'Speed' lets
    you choose the playback speed of the media. When bringing the selected
    media into your node graph then the viewing mode and playback speed will
    be adjusted accordingly by creating the additional nodes `Mirror` and
    `Retime`.

  - Optimize loading speed (#18)

1.2.0
-----
  - Add import processor to time offset media (#9)
  
    This update adds an additional import processor called 'TimeOffset'. By 
    default it is turned off. In order to enable it navigate to smartElement's
    import processor settings and set ``TimeOffset``'s ``enable`` flag from
    ``false`` to ``true``.
  
    This import processor creates a dialog on media insertion and asks the user
    if they want to let the media start at a specific frame or if they want to
    time offset the media to a specific value. The dialog contains a 'remember'
    checkbox that will remember the entered values and apply them to all
    upcoming media insertions as long as smartElement's media browser stays
    open.

  - Fix: After render copies from non existent paths under Windows (#10)

    Due to the fact that Windows uses back slashes which Nuke does not
    understand, files were not copied to the correct location after the render
    had finished. 

1.1.0
-----
  - Create import processors on importing media (#7)

    This update adds the feature to trigger custom code when importing media
    into the DAG. This can for example be used to copy media over to a folder 
    that is close to the current working file to keep all used dependencies 
    of a working file in one location. Or use it to increase a counter so that 
    you know how many times an element has been used. There are lots and lots 
    of scenarios where you can add custom import processors to customize 
    imports from smartElements to your needs. For an in-depth look how this 
    works please refer to the `advanced` page of our written documentation. 

  - Fix render whole frame range of video when ingesting a video (#8)

1.0.0
-----
  - Initial release

0.1.0
-----
  - Create Media API (#1)
  - Create Job API and processors (#2)
  - Create MVC (#3)
  - Scan for duplicate media when ingesting (#5)
  - Create documentation (#4)
  - Ingest toolsets and 3D data (#6)
