"""Add menu and commands to Nuke's menu."""

# Import third-party modules
import nuke

# Import local modules
from connect import osl as connect
from connect import helper


def add_to_ui():
    """Add menu and commands to Nuke's ui."""
    logo = helper.load_icons()["icon_logo"]

    menu_cragl = nuke.menu("Nuke").addMenu("cragl")
    menu_cragl.addCommand("connect", connect.load, "Shift+A", icon=logo)
    menu_cragl.addSeparator()


add_to_ui()
connect.init()
