"""Load the latest connect version on disk."""

# Import built-in modules
import os
import re

# Import third-party modules
import nuke


def _natural_sort(name):
    """Perform natural sort for sequence of given names.

    Args:
        name (str): The name to naturally sort with other names.

    Returns:
        :obj:`list` of :obj:`str`: Sequence of ints and strings to use for
            comparison of other lists of ints and strings.

    """
    return [
        int(t) if t.isdigit() else t.lower()
        for t in re.split(r"(\d+)", name)
    ]


def get_latest_connect_version():
    """Append the latest installed connect version from disk."""
    dirs = os.listdir(os.path.dirname(__file__))

    connect_versions = sorted([
        name for name in dirs
        if "connect_v" in name
        and not name.endswith("--")
    ], key=_natural_sort)

    nuke.pluginAddPath(str(connect_versions[-1]))
